## 封面
作者：天涯剑歌，执悲今厄
时间：2024.8.30
## 摘要
我们的Windows各程序运行时偶尔崩溃。为此我们查资料并整理了一套Windows Debug理论，并基于此而Debug。
本文在介绍Debug方法的过程中，也形象的介绍了许多Windows原理，例如：
- 通过航母的例子，解释零件为什么不能水洗
- 通过上级定位，解释为什么重做系统能解决99%的问题
- 通过列数字，直观的解释了为什么Windows轻易不崩溃
- 通过列数字，直观的解释了为什么图形界面无法取代CMD
- 以画正方形为例，解释了CMD指令的格式
- 以病人为例，解释了烤机的强大与风险
持有以下想法的人可以阅读本文：
- 如何对Windows Debug？
- Windows有哪些小知识？不要独立碎片的介绍，要把这些知识收束在一个框架下介绍。
## 标签
#关键词/Debug
#关键词/指令
#关键词/新建法
## 正文
### 必杀：重做系统
重启程序解决50%问题。
重启电脑解决90%问题。
重做系统解决99%问题。
不过，有些时候我们不想重做系统。不仅是因为做系统花时间，更是因为：
- 对于复杂办公电脑、重新安装软件并配置环境麻烦。
- 对于包含零散且重要的数据的电脑，数据迁移麻烦且可能疏忽（导致永久损失）。
这就需要使用其他办法。
题外话：重做系统法的一个上级是【新建法】，新建法下级还有【重生法：不要改变自己，而是新建空白意识并添加】【重构法：不要修改代码，而是新建空白项目并书写】。
### 小必杀：重新装机
许多问题来自于：线没插紧，线路老化接触不良，灰尘导致接触不良。
把所有线拔了，用毛刷给各个部位清灰，对不紧的线丢弃并买新的。
注意：电脑零件不可水洗。清灰只能使用干毛刷。
一般来说，所有电子产品都不能水洗。近年来出现防水手机，防水相机，可水洗电动牙刷，这背后付出了极高的成本并牺牲了许多扩展性。对于高速迭代的电脑产业，不可能有可水洗的零件。

插曲：扩展性：
万吨航母，最大的难点在哪？不是发动机，不是防空炮，而是外壳。如果不是在水里、需要控制体积与形状，而是在太空、随便组装后包一个球形外壳就行，那么航母将不存在【设计图】。
为了防水，航母牺牲了扩展性，每一个航母设计都是独一无二的、不可复用。许多发动机炮台等零件专门为某一个航母设计而开发，为了控制形状来放在外壳下的某一个位置，也同样不可复用。
如果航母的设计不需要考虑形状，那么航母技术的发展将比目前至少快两倍。
外壳，或者说，形状，是非常耗费精力与扩展性的。防水的重点就是外壳形状，因此，除非特别必要的东西（手机容易掉水里，相机水下拍摄，电动牙刷必然沾水），否则电子产品不会牺牲精力与扩展性来做防水。
### 小必杀：纯净模式
使用任务管理器，关闭前台与后台的各个非系统进程。只启动一个程序，看它是否崩溃。
如果无法关闭某些进程，那么在任务管理器里找到它的PID，使用CMD执行：
```csharp
taskkill /IM X /F
```
X为刚才找到的PID。
如果还是无法关闭，那么在任务管理器中关闭所有启动项，然后重启电脑。
如果某些启动项无法关闭，那么尝试找到它所在的服务，关闭服务、将服务激活模式从自动改为手动，然后关闭那个启动项。
如果某些服务无法关闭，那么在组策略中找到【关闭那个服务】的策略，并在任务计划中移除【启动此服务】的计划，并在注册表中将此服务的Start值设置为4，并将此服务的启动失败时行为设置为【无】，并且立刻重启电脑。注意，这些必须全部执行，否则任意一个疏忽都会导致此服务复活且各项设置复原——这是缺点、也是优点，多方唤醒，保证windows即便面临80%崩溃也能无声地自动修复。（即，你感受到一丁点崩溃，意味着windows已经遭遇了90%崩溃）
（此方案过于复杂。建议：如果遇到无法关闭的进程，那么放弃此方案，直接用下文的安全模式）
### 官方补丁
更新Windows系统，更新主板BIOS驱动，更新显卡驱动。
2024年初，英特尔13/14代CPU开始出现大规模故障。2024.7，英特尔找到原因并给出解决方案，最新BIOS驱动已修复此问题。（原因：电压参数出错，导致CPU一直在高电压下工作，从而故障率高）

要更新主板驱动，需要搜索：
- 如何查看自己电脑的主板信息（并执行）
- XX官网（自己主板的公司官网）
在官网下载最新驱动后，将其保存到U盘，然后重启电脑，启动过程中不断按DEL键，直至进入黑白色的BIOS界面，点击Flash，会自动重启，重启后选择U盘中的驱动，就会自动开始更新。

注意：驱动的安装文件最好放在U盘，这样的话即便安装过程出错也只损坏U盘。否则可能损坏系统。
驱动安装完毕后可以删除U盘。

注意，平时不建议更新。建议关闭windows自动更新服务（办法见于上文纯净模式中关闭服务的办法）。
更新固然可以修复一些过去的漏洞，但也有小概率导致不兼容、出现新的bug。
### 安全模式
以安全模式启动电脑，然后执行各种系统自检。
安全模式只会加载系统所需的最少组件。安全模式下，各种自启动的病毒都无法启动。（除非系统核心文件被感染）

安全模式的进入方式：
- 按住shift，点击重启。重启后蓝屏
- 疑难解答，高级，启动选项。重启后蓝屏
- 按4（字母区域上方的4，而非数字小键盘）。重启后进入安全模式
### 安全模式：系统自检
检查系统文件是否损坏，并自动修复。
打开CMD，输入代码后回车执行：
```csharp
sfc /scannow
```
然后你什么也不用做。它会显示检查进度，100%后你可以重启电脑看看是否还有问题。

注：CMD打开方式：按下键盘win+R，出现输入框，输入cmd，点击确认。
CMD就是各大影视剧中黑客所使用的黑色命令行窗口。它是最方便的执行指令的方式，一切指令都是一行代码，而不需要使用鼠标点开左一个右一个窗口。
一个窗口最多显示一百个指令（按钮/选择框），然而二十个字符支持超过一亿亿亿种指令。绝大多数指令都只有CMD可用，没有对应的图形窗口。
一个电脑高手必须习惯于CMD的方式，CMD效率远高于鼠标。
窗口适合展示信息，CMD适合执行动作。（修订者注：窗口适合读，CMD适合写。）
### 安全模式：内存自检
安全模式下，在CMD执行：
```csharp
mdsched.exe
```
出现弹窗，点击立刻重启。然后会重启并开始内存检查，检查结束后自动重启进入桌面。
检查结果在【事件查看器】中。打开事件查看器的办法：
1. 按下WIN+R，输入eventvwr.msc，确认。出现新窗口
2. 在目录树中选择：windows日志 系统
3. 按时间排序，查看最新的几个日志
### 安全模式：硬盘自检
安全模式下，在CMD执行：
```csharp
chkdsk C: /f /r
```
自动开始检查并修复C盘中的错误。
如果遇到硬件损坏，那么会在CMD中告诉你。
检查可能需要几个小时。期间电脑不可关机。

CMD指令的格式：指令名 参数 参数 参数……
事实上，现实中每一个指令也都是如此。例如【画一个正方形】，本质是：
- 定义：画画 某人 某位置 某形状 某半径（半径基于最大外接圆）
- 调用：画画 你 纸中央 正方形 5
### 安全模式：杀毒
在安全模式下使用杀毒软件全盘扫描。
预计也需要几个小时。
不建议使用Windows Defender来杀毒。它实力一般，平时还经常自动扫描、且扫描时占用大量系统资源、导致办公卡顿。
360杀毒实力最强，甚至超越许多美国著名杀毒软件。但它会误删一些你自己开发的小程序，并且它的各种广告弹窗、360全家桶、浏览器劫持、数据窃取等流氓行为很烦。
- 360全家桶：如果你安装了一个360公司开发的程序，那么往往你的电脑里会自动冒出来一个又一个其他的360公司开发的程序。这是因为360会后台偷偷给你的电脑安装其他程序（这种行为属于病毒。360会帮你组织其他程序的偷偷安装，但不会阻止自己）。
- 广告弹窗：不仅限于右下角弹窗，甚至还会在屏幕中央弹窗，非常打断办公思路。不过近年来随着投诉与卸载量的增加，360渐渐收敛了弹窗，你可以在设置中关闭弹窗。（不过关闭很麻烦，需要在好几个犄角旮旯里找到关闭选项。一个简单的办法是：假装卸载，它会弹窗【别卸载我。卸载是因为弹窗吗？我不弹了】，你点击【是】就自动设置关闭弹窗了。卸载时要使用控制面板，而不是软件内置的卸载）
- 浏览器劫持：会篡改你的浏览器主页，使得你打开浏览器后进入360浏览器。
- 数据窃取：360会窃取你的各种信息，包括但不限于QQ聊天记录、浏览器记录，甚至还会偷偷开启录音机与摄像头。这种行为也是大多数国产软件的标配，比如QQ、淘宝。
火绒最安静，无弹窗、无劫持、无各种流氓行为。但杀毒能力一般（平时也够用）。
建议：如果各个其他办法都没用，那么先使用火绒杀毒，再不行就用360。
### 烤机
烤机，就是让电脑以全功率运转。
烤机可以充分暴露硬件问题。如果烤机期间，原本偶然崩溃的程序加速崩溃，那么就可以确认问题在于硬件。如果无变化，那么问题确认是软件病毒。
注意！！！烤机强大而危险，最好在专业人士远程或线下指导下进行。烤机可能直接让电脑报废，需要时刻关注电脑的状态。烤机过少可能不足以暴露问题，过多可能让电脑损坏。
烤机时需使用烤机软件。烤机主要分为烤显卡、烤CPU、全烤（带内存硬盘）。

烤机的本质相当于：一个人生病了，不知道他是筋骨肉的机械损伤、还是病原体带来的疾病。那么就让他全速跑步，如果他跑着跑着开始飙血，那么意味着他是筋骨肉机械损伤。
跑的太少不足以暴露问题，跑的太多可能直接跑死他。这就是烤机的风险。
### 开发团队反馈
许多程序在崩溃时都会生成日志，并建议你反馈给开发团队。例如LOL Unity QQ。
还有的程序虽然没有弹窗，但是有日志、有官方群，群内有官方技术人员接受反馈。例如火绒、搜狗输入法。
如果你遇到【各个程序莫名其妙偶尔崩溃】的问题，那么你可以将各程序的日志发送给各自的开发团队，他们会免费尝试帮你debug。
发送时建议详细描述你所知的故障发生背景、你的设备信息、你执行过但失败的debug过程。

注意：不建议找淘宝或电脑城的人帮你修。他们的水平还不如本文，他们只会在你的电脑上安装一堆他们的病毒程序来以毒攻毒式的应对，如果还是不行、那么他们会让你重做系统。